/*
  Correct form:  VMLOGON sid uid pw cmd

  sid = one letter session ID.
  uid = vm userid
  pw  = password
  cmd = command to execute (defaults to CP BEGIN)

VMLOGON is called from OS/2 to log a user onto a CM session.  Either
a local, LAN, or host session can be specified.  It is a sample program
that demonstrate the use of HLLAPI for session automation.  You can put
a call to VMLOGON in AWSUSER.CMD to have P/370 sessions come up 'already
logged on' and in the user application.  This is only a sample program;
you may have to modify it to meet your needs.

If the session is already logged on to a userid, then the exec gives
an error message.

Restrictions:  The system prompts (USERID, MORE, PASSWORD, etc. must be
in English)

VMLOGON uses the REXX HLLAPI package  (SAAHLAPI.DLL)

RC=1: couldn't get a logon screen
rc=2: Error from CP LOGON command (invalid password, userid, etc.)
rc=3: Session already connected.
*/
/**/  trace e;
'@ECHO OFF';
arg sid uid pw cmd
if words(sid uid pw)\=3
   then do;
           do i=2 while sourceline(i)\='*/'
              say sourceline(i);
           end;
           exit 100;
        end;
if cmd='' then cmd='CP BEGIN';
if rxfuncquery('hllapi')
   then call rxfuncadd 'hllapi','saahlapi','hllapisrv';


/* wait for CM to come up */
do i=1 to 10;
   call hllapi 'connect',sid;
   if result=0 | result=5 then leave;
   z=hllapi('pause',10);
end;
if result=9
   then do;
             say 'Could not get connection to session' sid
             exit 9
        end;
/* From now on, wait for either timeout or for host update */
z=hllapi('set_session_parms','ipause');
z=hllapi('start_host_notify',sid,'P');

/* try to send in an initial "clear", wait for something */
call hllapi 'sendkey','@C';
   z=hllapi('wait');
   z=hllapi('query_host_update',sid);

running=0;  /* count of how many times we've seen "running" message */
do j=1 to 4;
   call hllapi 'sendkey','@C';
   z=hllapi('wait');
   do i=1 to 5;
      z=hllapi('query_host_update',sid);
      /* is there a non-full screen logon prompt? */
      call hllapi 'search_ps','Enter one of',1;
      if result\=0 then leave j;
      call hllapi 'search_ps','not valid before',1;
      if result\=0 then leave j;

      /* is it a virtual machine screen? */
      call hllapi 'search_ps','VM READ',1600
      if result\=0 then signal already;

      /* Look for either the end of a logoff screen,   */
      /*   or for a "more...." screen,                 */
      /*   or for a LOGON screen.                      */
      /* For any of these, send a clear and try again. */
      if hllapi('search_ps','enter or clear to continue',1) ,
        +hllapi('search_ps','MORE...',1600)                 ,
        +hllapi('search_ps','HOLDING',1600)                 ,
        +hllapi('search_ps','USERID  ',1 )                  ,
        >0
         then do;
                   call hllapi 'sendkey','@C';
                   z=hllapi('pause',10);
                   iterate i;
              end;

      /* if we are in CP READ, type junk and so we can see what msg we
         if it will type a logon prompt */
      if hllapi('search_ps','RUNNING',1600)>0
         then do;
                 running=running+1;
                 if running>3 then signal already;
                 call hllapi 'sendkey','CP BEGIN@E';
                 z=hllapi('pause',10);
              end;
      call hllapi 'search_ps','CP READ',1600
      if result\=0
         then do;
                 call hllapi 'sendkey','ASDF @E';
                 z=hllapi('pause',5);
              end;
      z=hllapi('pause',15);
   end;
end;

z=hllapi('query_host_update',sid);
if j=5
   then do;
            say 'Couldnt get the logon screen';
            rc=1;
            signal xit;
        end;
/*-------------------------------------------------------------*/
/* We are now at a place where we can issue the logon command  */
/*-------------------------------------------------------------*/

/* send in an enter, then LOGON uid ENTER, then password and ENTER */
 call dosend '@C' ;
 call dosend 'LOGON' uid '@E';
 call dosend pw '@E' ;

/* look for a response.  If it is 'LOGON AT' or 'RECONNECTED AT'  */
/* then we made it.                                               */
/* if it is DMKLOG05xx, then we failed.                           */
do i=1 to 10;

   z=hllapi('query_host_update',sid);
   if hllapi('search_ps','LOGON AT',1)>0      then leave i;
   if hllapi('search_ps','RECONNECTED AT',1)>0 then leave i;

   z=hllapi('search_ps','DMKLOG05',1)
   if z>0
      then do;
               k=hllapi('copy_ps_to_str',z,80);
               say k;
               msg= 'LOGON' substr(uid':' delword(k,1,1),1,60);
               rc=2;
               signal xit;
           end;
   z=hllapi('pause',30)
end;
z=hllapi('pause',5);
z=hllapi('query_host_update',sid);

/* send in a 'CP BEGIN' to get through the autoread or restart after */
/* reconnecting... */
call hllapi 'sendkey','@C';
z=hllapi('pause',10);
call hllapi 'sendkey',cmd '@E';
msg=uid;
signal xit;

/* come here if user is session is already logged on */
already:
   msg='';
   say 'Session is currently logged on';
   rc=3;
xit:
/* disconnect */
z=hllapi('disconnect');
xrc=rc;
if msg\='' then 'ltrename' sid msg;
exit xrc;

dosend: parse arg q;
   z=hllapi('query_host_update',sid);
   z=hllapi('WAIT');
   x=hllapi('sendkey',q);
   z=hllapi('PAUSE',10);
   z=hllapi('query_host_update',sid);
   return x;
