/* P/370 (370-mode VM only)                                  2/15/96  */
/*                                                                    */
/* 7/19/93 JAH Original version                                       */
/* 2/15/96 JAH Add more DASD types                                    */
/*                                                                    */
'@ECHO OFF';
Trace o
/*---------------------------------------*/
/* Check input parameters                */
/*---------------------------------------*/
Parse upper arg sysres cmd old new opt .
If (sysres = '?')|(sysres = '') then do
   Say 'Correct Form is:   SYSOWN [d:\path\]sysres.ext LIST'
   Say '                                               SEARCH'
   Say '                                               REPLACE old new [/y]'
   Say 'Use this command to avoid rebuilding the CP nucleus whenever you want to add'
   Say 'a new volume, such as a shared segment, to the CP SYSOWN list.'
   Say 'This list is originally defined in DMKSYS ASSEMBLE.'
   Say ''
   Say 'The Starter System CP nucleus (SYSRES.300) has "extra" SYSOWN volume names'
   Say 'defined (such as SEG001 - SEG016) that can be used as slots for new names.'
   Say ''
   Say 'This command will look in file "sysres" for the SYSOWN list and either LIST'
   Say 'all the SYSOWN volume names, or REPLACE an existing (old) name with a new name.'
   Say 'The CP label on the file is used to search for the SYSOWN list, and cannot'
   Say 'itself be replaced in the SYSOWN list.'
   Say ''
   Say 'SEARCH is the same as LIST, but in addition the current DEVMAP file is examined'
   Say 'and the first entry that matches the volume name is displayed.'
   Say ''
   Say 'Volume names must be 6 characters or less in length. You must stop the P/370'
   Say 'Program before executing this command. Use the "END 370 Processor" icon.'
   Say ''
   Say 'You will be prompted before the file is modified, unless /y is specified.'
   Exit
   end

If (cmd = 'REPLACE')|(cmd = 'LIST')|(cmd = 'SEARCH')
   Then Do;
   If (cmd='REPLACE')&,
    ((old='')|(new='')|(length(old)>6)|(length(new)>6)) then
      Do;
      Say 'Invalid parameters. You must specify both an "old" and "new"'
      Say 'volume name that are 1 to 6 characters in length.'
      Exit 1
      End
   End;

   Else Do;
   Say 'Invalid option' cmd'.'
   Exit 2
   End

/*-------------------------------------------*/
/*  Set up ASCII <-> EBCDIC translate tables */
/*-------------------------------------------*/
Call a2e
Call e2a

dasdlist='3370 3310 0671 9332 9335 9336 FB-5 3330 3350 3375 3380 3390 9345'
                /* Only 4 chars tested  ---+          */

/*-------------------------------------------*/
/* Read SYSRES volume one page at a time     */
/*-------------------------------------------*/
label=charin(sysres,513,10)              /* Check the volume label */
If Substr(label,1,4)=Translate('VOL1',ebcdic) then
   volid=Substr(label,5,6)||'FFFF'x      /* Search argument        */
   Else Do;
      Say 'This does not appear to be CP volume. Nothing done.'
      Exit 3
      End;

Do i = 0 to 400
   offset=1+i*4096
   z=charin(sysres,offset,4096)
   x=Pos(volid,z)                         /* Look for "SYSRES" */
   If x>0 then leave                      /* SYSOWN list found */
   end /* Do i = 0 to 400 */

If i = 401 then do
   Say 'SYSOWN list not found in file' sysres'.  Check filename.'
   Exit 4
   End;

/*---------------------------------------------*/
/* LIST: Print a List of the volume names      */
/*---------------------------------------------*/
If (cmd = 'LIST')|(cmd = 'SEARCH') then do
   numvols = c2d(Substr(z,x-1,1))
   Say 'Number of SYSOWNed volumes =' numvols
   Do j=0 to numvols-1
      w=Substr(z,x+j*8,6)
      w=translate(w,ascii)
      If cmd = 'LIST' then Say w
      Else do
         result=''
         Call devmap w    /* Search for cp label in devmap */
         Say w result     /* Print label and filespec, if found */
         end
      end
   Exit
   End;  /* List */

/*----------------------------------------------*/
/* REPLACE: Replace an old name with a new name */
/*----------------------------------------------*/
If (old='SYSRES')|(new='SYSRES') then do
   Say 'You can not specify the name "SYSRES" for either the old or new volume name.'
   Exit 5
   End;

old = Left(old,6)                         /* Pad on right with blanks */
new = Left(new,6)
oldebc = translate(old,ebcdic)||'FFFF'x   /* Search argument */
newebc = translate(new,ebcdic)||'FFFF'x
y=Pos(oldebc,z)                           /* Look for old name */
If y = 0 then do
   Say 'Volume label' old 'not found in volume' sysres'. Nothing done.'
   Exit 6
   End;

location = offset+y-1
oldvol=charin(sysres,location,8)
If oldvol <> oldebc then do
   Say 'Unexpected error reading old volume label.'
   Exit 7
   End

/*                                    */
/* Give the user a chance to back out */
/*                                    */
Say 'Replacing' Translate(oldvol,ascii) 'with' Translate(newebc,ascii) '...'
If opt = '/Y' then nop
Else Do;
   Say 'Do you wish to proceed? (Yes|No)'
   Parse upper pull ans
   If (Ans='Y')|(Ans='YES') then nop
      Else do;
      Say 'Nothing done.'
      Exit 8
      End
   End

/*----------------------------------------------*/
/* Replace the characters in the file           */
/*----------------------------------------------*/
Call Charout sysres,newebc,location
If result <> 0 then do
   Say 'Unexpected error writing new volume label.'
   Exit 9
   End
Say 'CP volume' sysres 'has been updated.'

EXIT

/*-------------------------------------------------------------*/
e2a:
asc0= ,
 /* 0 1 2 3 4 5 6 7 8 9 A B C D E F */,
  '00010203CF09D37FD4D5C30B0C0D0E0F'X  ||  /* NUL SOH STX ETX 207 HT 211 DEL 212 213 195 VT FF CR SO SI */,
  '10111213C7B408C91819CCCD831DD21F'X;     /* DLE DC1 DC2 019 199 180 BS 201 CAN EM 204 205 131 029 210 031 */
asc20= ,
  '81821C84860A171B89919295A2050607'X  ||  /* 129 130 FS 132 134 LF ETB ESC 137 145 146 149 162 ENQ ACK BEL */,
  'E0EE16E5D01EEA048AF6C6C21415C11A'X;     /* 224 238 SYN 229 208 RS 234 EOT 138 246 198 194 DC4 NAK 193 SUB */
asc40= ,
  '20A6E180EB909FE2AB8B9B2E3C282B7C'X  ||  /* SPC 166 225 128 235 144 159 226 171 139 155 . < ( + | */,
  '26A9AA9CDBA599E3A89E21242A293B5E'X;     /* & 169 170 156 219 165 153 227 168 158 ! $ * ) ; ^(circ) */
asc60= ,
  '2D2FDFDC9ADDDE989DACBA2C255F3E3F'X  ||  /* - / 223 220 154 221 222 152 157 172 186 , % _ > ? */,
  'D78894B0B1B2FCD6FB603A2340273D22'X;     /* 215 136 148 176 177 178 252 214 251 Oquote : #  ' = " */
asc80= ,
  'F861626364656667686996A4F3AFAEC5'X  ||  /* deg abcdefghi 150 164 243 175 174 197 */,
  '8C6A6B6C6D6E6F7071729787CE93F1FE'X;     /* 140 jklmnopqr 151 135 206 147 241 254 */
ascA0= ,
  'C87E737475767778797AEFC0DA5BF2F9'X  ||  /* 200 126 stuvwxyz 239 192 218 [ >=(242) bul(249) */,
  'B5B6FDB7B8B9E6BBBCBD8DD9BF5DD8C4'X;     /* 181 182 253 183 184 185 230 187 188 189 141 217 191 ] 216 196 */
ascC0= ,
  '7B414243444546474849CBCABEE8ECED'X  ||  /* lcb ABCDEFGHI 203 202 190 232 236 237 */,
  '7D4A4B4C4D4E4F505152A1ADF5F4A38F'X;     /* rcb JKLMNOPQR 161 173 245 244 163 143 */
ascE0= ,
  '5CE7535455565758595AA0858EE9E4D1'X  ||  /* Rev-sl 231 STUVWXYZ 160 133 142 233 228 209 */,
  '30313233343536373839B3F7F0FAA7FF'X;     /* 0123456789 179 247 240 250 167 255 */
ascii=asc0||asc20||asc40||asc60||asc80||ascA0||ascC0||ascE0;
return ascii


a2e:
/* Set up (PC) ASCII to EBCDIC translate table */
ebc0= ,
 /* 0 1 2 3 4 5 6 7 8 9 A B C D E F */,
  '00010203372D2E2F1605250B0C0D0E0F'X  ||,  /* NUL SOH STX ETX EOT ENQ ACK BEL BS HT LF VT FF CR SO SI */
  '101112133C3D322618193F27221D351F'X;      /* DLE DC1 DC2 DC3 DC4 NAK SYN ETB CAN EM SUB ESC FS GS RS US */
ebc20= ,
  '405A7F7B5B6C507D4D5D5C4E6B604B61'X  ||,  /* spc !"#$%&'()*+,-./  */
  'F0F1F2F3F4F5F6F7F8F97A5E4C7E6E6F'X;      /* 0123456789:;<=>?  */
ebc40= ,
  '7CC1C2C3C4C5C6C7C8C9D1D2D3D4D5D6'X  ||,  /* @ABCDEFGHIJKLMNO  */
  'D7D8D9E2E3E4E5E6E7E8E9ADE0BD5F6D'X;      /* PQRSTUVWXYZ[\]_  */
ebc60= ,
  '79818283848586878889919293949596'X  ||,  /* `abcdefghijklmno  */
  '979899A2A3A4A5A6A7A8A9C04FD0A107'X;      /* pqrstuvwxyz       */
ebc80= ,
  '4320211C23EB249B7128384990BAECDF'X  ||,
  '45292A9D722B8A9A6756644A53685946'X;
ebcA0= ,
  'EADA2CDE8B5541FE5851524869DB8E8D'X  ||,
  '737475FA15B0B1B3B4B56AB7B8B9CCBC'X;
ebcC0= ,
  'AB3E3B0ABF8F3A14A017CBCA1A1B9C04'X  ||,
  '34EF1E0608097770BEBBAC5463656662'X;
ebcE0= ,
  '30424757EE33B6E1CDED3644CECF31AA'X  ||,
  'FC9EAE8CDDDC39FB80AFFD7876B29FFF'X;
 /* 0 1 2 3 4 5 6 7 8 9 A B C D E F */,

ebcdic=ebc0||ebc20||ebc40||ebc60||ebc80||ebcA0||ebcC0||ebcE0;
return ebcdic
/*-------------------------------------------------------------*/
Devmap:   /* Search current devmap for the cp label */
          /* Return the complete filespec if found  */
arg label .
'awsprof /q >awsdev.loc' /* Read DEVMAP location out of OS2.INI */
ini=linein('awsdev.loc');
call lineout 'awsdev.loc'; /* close file */
'ERASE awsdev.loc'
If ini='(Not Found)' then do
  cmd='LIST' /* shut off search */
  return '';
  end
else idev=ini
devline=linein(idev);      /* see if it exists   */
call lineout idev;         /* close file         */
If devline = '' then do
  cmd='LIST' /* shut off search */
  return '';
  end

/*                                   */
/*  Read DEVMAP one record at a time */
/*                                   */
do i=0 to 400;
   devline=charin(idev,1+i*64,64);      /* read a line from devmap */
   if length(devline)=0 then do            /* done but not found   */
      call lineout idev;                   /* close file           */
      return '';
      end
/*                               */
/*  Process DASD records         */
/*                               */
   Else do
   type=wordpos(substr(devline,3,4),dasdlist)  /* non-zero is it is DASD */
   If (type > 0)&(substr(devline,11,6)=Left(label,6))
      then do;
      zz=Substr(devline,19)
      Lrec=Length(Filespec('P',zz)||Filespec('N',zz))
      result=Substr(zz,1,Lrec)
      return result              /* Return file spec */
      End;
   End;
End; /* i=0 to 400 */
