/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
call sysfiletree '*.RAM', 'new.', 'F'
call sysfiletree '*.SNT', 'snt.', 'F'
select;
  when new.0=0 & snt.0=0 then do;
      Say 'There are no new or old logs to up load'
      Say 'Press enter to quit';
      pull x;
      exit 1;
  end;
  when new.0=0 then do;
      Say 'There are no new logs to upload.';
  end;
  when new.0>0 then do;
      Say 'Here are the new logs that have not yet been sent'
  end;
  otherwise;
end;
k=1;
say 'LogNumber Date Time LogName'
do i=1 to new.0;
    say k new.i;
    k=k+1;
end;
if snt.0>0 then say 'Here are the old logs that have already been sent';
do i=1 to snt.0
   say k snt.i;
    k=k+1;
end;

Say 'Enter the number of the log you want to work with or Q to quit'
do forever;
   pull x;
   select;
     when x='Q' then exit 1;
     when datatype(x,'N') & x<k &x>0 then leave;
     Otherwise say 'Invalid Selection. Enter log number, or Q';
   end;
end;

if x <= new.0
   then do;
             fn = word(new.x,words(new.x));
             say 'Enter Problem Number to upload problem file' fn;
             say 'or DELETE to delete it, or QUIT to exit';
             do forever;
                pull pn junk
                select;
                 when pn='QUIT' then exit;
                 when pn='DELETE' then do;
                      'ERASE' word(new.x,words(new.x));
                      exit;
                 end;
                 when length(pn)<6 then say 'Invalid Problem Number';
                 otherwise leave;
                end;
             end;
             Say 'Enter a description of the problem'
             Say 'Enter a null line to terminate'
             do forever;
                parse pull des
                if des = '' then leave;
                call lineout 'DESCRIBE.LOG',des;
             end;
             'RENAME' fn pn'.RAM';
             if rc<>0
                then do;
                         say 'Log file could not be renamed';
                     end;
                else fn = pn||'.RAM';
             call lineout 'DESCRIBE.LOG';
             'SAVERAM2 DESCRIBE.LOG' fn '/E /Qt';
             '@ERASE DESCRIBE.LOG';
             call upload fn;
             xrc=ftplogoff();
             if result=0
                then do;
                         'RENAME' fn '*.SNT';
                         if rc=0
                            then say 'Log' fn 'Uploaded and renamed to *.SNT';
                            else say 'Log' fn 'Uploaded but rename failed';
                         exit;
                     end;
                else do;
                         say 'Upload failed';
                         exit result;
                     end;
        end;

x=x-new.0;  /* adjust to the files already sent */

             fn = word(snt.x,words(snt.x));
             do forever;
                say 'Enter RESEND upload problem file' fn 'again';
                say 'or DELETE to delete it, or QUIT to exit';
                pull pn junk
                select;
                 when pn='QUIT' then exit;
                 when pn='DELETE' then do;
                      'ERASE' word(new.x,words(new.x));
                      exit;
                 end;
                 when pn='RESEND' then leave;
                 otherwise say 'Invalid Request';
                end;
             end;
             call upload fn;
             xrc=ftplogoff();
             if result=0
                then do;
                     say 'Log' fn 'uploaded again';
                          exit;
                     end;
                else do;
                     say 'Error uploading log' fn
                          exit;
                     end;



exit
upload:
 arg upfn;
             n = pos('\',reverse(upfn));
             if n = 0 then n = pos(':',reverse(upfn));
             if n = 0 then n = length(upfn)+1;
             n  = n-1;
  fnx = right(upfn,n);
  parse var fnx fnx '.' xyz
  ftpfn = fnx||'.RAM';
/* try rexx ftp functions crb 12/10/97 */
rc=RxFuncAdd("FtpLoadFuncs","rxFtp","FtpLoadFuncs");
rc=FtpLoadFuncs()
rc=FtpSetUser("p390.ibm.com","anonymous","berghorn@vnet.ibm.com");

/*
rc=ftpsys(opsys);
if rc=0
   then say 'Target running' Opsys
   else do;
            say "Error" ftperrno
            say "Nothing uploaded"
            return 1;
        end;
*/
rc=ftpchdir('/incoming');
if rc\=0 then say 'Bad RC from ChDir' frperrno

Say 'Starting FTP:' upfn 'to' ftpfn 'in Binary';
rcup=ftpput(upfn,ftpfn,"BINARY");

if rcup=0 then say 'Put went ok';
          else say 'Put failed, rc='rcup 'ftperrno='ftperrno

rc=ftplogoff();
if rc\=0 then say 'Bad RC from logoff' ftperrno
return rcup;
