/* P/390 Artic960 & Parca Install program     ver 2.3.3     9/24/97 JAH        */
/*                                                                             */
/*                                                                             */
trace o
"@ECHO OFF"
card = 'P/390';subd = 'P390';
title = card 'Parca & Artic960'
ricpath = 'C:\RIC'
ricbpath = 'C:\RIC\BIN'
needed = 2131600  /* bytes needed on C: drive for \RIC\BIN                   */
fix_level = '2021'   /* Installed code must be Fixpack 2.2.1 or... */
fix_lvl = '2.2.1'
base_level = '2030'  /* ...diskettes at 2.3 level */
base_lvl = '2.3'

Parse upper arg arg1 .
If arg1 = '?' then do
Say 'Correct Form is:'
Say '                INSTICE'
Say ''
Say 'Use this command to install the' title 'programs.'
Say 'INSTICE.CMD, PARCA.ZIP, and ARTIC960.ZIP must all be located in the same'
Say 'place, e.g. A:\ or D:\P390. If running from diskette, you will be'
Say 'prompted for the location of the P/390 programs.'
Say ''
Say 'Note that some files must also be installed on the C: drive in the'
Say 'C:\RIC\BIN subdirectory.'
Say ''
Say 'Make sure all' card 'programs are stopped before running this install.'
Say 'If you have previously installed this support, older versions will be replaced.'
   Exit
   End

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

Parse upper Source . . srcname .  /* Info on the program as called */
sletter = Filespec('Drive',srcname) /* e.g. a:            */
ssubd = Filespec('Path',srcname)    /* e.g. \path\        */
spath = sletter||ssubd              /* e.g. a:\path\      */

complete=0  /* non-zero if OK */
Error=0     /* non-zero if any errors */

/*--------------------------------------------------------------------*/
/* Check for a drive letter(s) passed as parameter to INSTALL         */
/*--------------------------------------------------------------------*/
   parse upper arg tletter .   /* to drive */
   parse var tletter tletter ':' .  /* strip off : if provided */

If tletter='' then do
   Call SysCls
   Say ''; Say title 'Installation';
   Say '-----------------------------------'
   say ''; Say 'To continue with installation press Y';
   Say '(any other key to EXIT).';
   parse upper value SysGetKey('NOECHO') with key
   If key<>'Y' Then Exit 1

   Call GetP390  /* Find the P390 drive letter in CONFIG.SYS. Sets "dletter" */

   If ssubd = '\P390\' then do   /* Run from hard drive */
      tletter=Left(sletter,Length(sletter)-1) /* without training ":" */
      tpath=Left(spath,Length(spath)-1)       /* without trailing "\" */
      End;

   Else do
      Say '';
      Say 'What is the drive letter of the \'subd' subdirectory?'
      Say 'Type in the letter of the destination disk (To accept default = 'dletter', press ENTER).';
      parse upper value SysGetKey('NOECHO') with key
      If key='0D'x then do
         tpath=dletter':\'subd
         tletter=dletter
         end
      Else do
         tpath=key':\'subd
         tletter=key;
         end
      End; /* prompt user */
   End; /* blank tletter */
Else tpath=tletter':\'subd

z1 = stream(tpath'\SYSLEVEL.AWS','C','QUERY EXISTS')
If z1 = '' then do
   Say 'The P/390 Programs are not installed in' tpath
   Say '(or' tpath'\SYSLEVEL.AWS not found).'
   Say '*** Nothing done. ***'
   Exit 2;
   end

If arg1 = '' then do  /* If user invoked, check these. Don't check if called from INSTALL.CMD */
   Call ChkP390 /* Find out what level of P/390 Program code is installed */
   Call ChkPgm  /* check to see is any P/390 programs are running */
   end;

Say ''
Say 'Installing' title'...'
Say ''
/*--------------------------------------------------------------------*/
/* Check free space on the C: drive                                   */
/*--------------------------------------------------------------------*/
tinfo = SysDriveInfo('C:')
If tinfo = '' then Signal NodiskT
Parse var tinfo . tfree . .
If tfree < needed then Signal Nospace1

/*--------------------------------------------------------------------*/
/* Unzip the files                                                    */
/*  File 1: Artic960 OS/2 support files to C:\RIC\BIN                 */
/*  File 2: Parca support files to d:\P390                            */
/*--------------------------------------------------------------------*/
filename1 = spath'ARTIC960.ZIP'
filename2 = spath'PARCA.ZIP'

z1 = stream(filename1,'C','QUERY EXISTS')
If z1 = '' then do
   Say 'The file' filename1 'was not found.'
   Say '*** Nothing done. ***'
   Exit 2;
   end

z2 = stream(filename2,'C','QUERY EXISTS')
If z2 = '' then do
   Say 'The file' filename2 'was not found.'
   Say '*** Nothing done. ***'
   Exit 2;
   end

/* Make sure we have the unzip program */
z2 = stream(tpath'\PKUNZIP2.EXE','C','QUERY EXISTS')
If z2 <> '' then zpath = tpath'\'
Else Do
   z3=SysSearchPath('PATH','PKUNZIP2.EXE')
   If z3 = '' then do
      Say 'Required program PKUNZIP2.EXE not found. P/390 Program diskettes must be installed.'
      Say '*** Nothing done. ***'
      Exit 3;
      End
   Else zpath = ''
   End; /* Search for a copy */

Say 'Unzipping ' filename1 'to C:\RIC ...';
zpath"PKUNZIP2 -o -d" filename1 ricpath "> nul:"
z2rc=rc
If z2rc <> 0 then error = error + 1
If z2rc = 1 Then Say 'Some active files could not be replaced, installation continues...'
If z2rc > 1 then Do
   Say '** ERROR unzipping' filename1'. See error messages listed above.'
   Exit z2rc /* QUIT */
   End; /* error */

Say 'Unzipping ' filename2 'to' tpath '...';
zpath"PKUNZIP2 -o -d" filename2 tpath"\ > nul:"
z1rc=rc
If z1rc <> 0 then Do
   Say '** ERROR unzipping' filename2'. See error messages listed above.'
   Exit z1rc /* QUIT */
   End; /* error */

complete=complete+1       /* non-zero if we have completed this step */

/*--------------------------------------------------------------------*/
/*  E X I T  code                                                     */
/*--------------------------------------------------------------------*/
Exit:
If complete > 0 then do  /* Only say if we have actually done something */
   Say ''
   If error<>0 then Do
      Say title 'programs copied, but errors occurred.'
      Say '-----------------------------------------------'
      If z2rc = 1 then do
         Say 'If you were reinstalling these programs and some files could'
         Say 'not be replaced, "rem" out DEVICE='ricbpath'\RICIO16.SYS '
         Say 'in CONFIG.SYS, reboot OS/2, and retry this install.'
         End
      End
   Else Do
      Say title 'programs copied.'
      Say ''
      If arg1 = '' then do /* If user invoked, then print instructions */
      /* ** Call UpConfig ** tell user to do it instead: */
         Say 'Edit CONFIG.SYS to remove the "rem" characters from in front of:'
         Say '   DEVICE='ricbpath'\RICIO16.SYS'
         Say '   SET RICPATH='ricpath
         Say 'Make sure' ricbpath'; is in the LIBPATH, PATH, and DPATH statements.'
         Say 'Shutdown and reboot OS/2.'
         End;  /* Manual installation */
      End; /* No errors */
   End; /* complete non-zero */
Exit 0
/*------***************************-----------------------------------*/
/*----- S U B R O U T I N E S       ----------------------------------*/
/*------***************************-----------------------------------*/

GetP390:
/*---------------------------------------*/
/* Find what drive P/390 programs are on */
/*---------------------------------------*/
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'

/* Read in CONFIG.SYS file one line at a time */
Do i=1 by 1 While Lines(config)
   cline = Linein(config)
   Parse upper var cline rem .
   If Strip(rem) = 'REM' then iterate
   Parse upper var cline . 'SET PATH=' ppath
   If ppath <> '' then leave /* Found the line we want */
   End;
Call Stream config,'C','CLOSE'
If ppath = '' then do  /* If we can't locate CONFIG.SYS, take default */
   dletter='D'
   Return
   End;

/*                                                             */
/*  Extract drive letter from first d:\P390; statement on line */
/*                                                             */
pp390 = Pos(':\'subd';',ppath)
If pp390 = 0 then do  /* Can't find one */
   dletter='D' /* Can't find P390 - assume default */
   Return
   End;

dletter = Substr(ppath,pp390-1,1)  /* Grab P390 drive letter */
If (length(dletter)<>1 | Datatype(dletter,'U')<>1) Then dletter = 'D';
dpath=dletter':\'subd

Return;

/*--------------------------------------------------------------------*/

ChkP390:
/*---------------------------------------------------------------------------*/
/* Check to see what level of P/390 is installed                      */
/*---------------------------------------------------------------------------*/
syslvl=tpath'\SYSLEVEL.AWS'
dd = Stream(syslvl,'C','QUERY EXISTS') /* Make sure d:\P390 subdirectory exists */
If dd = '' then do
   Say "Subdirectory '"tpath"' does not exist (or" tpath"\SYSLEVEL.AWS not found)."
   Say '*** Nothing done. ***'
   Exit 1
   End;

file=charin(syslvl,1,200)           /* Check version of P/390 X.YY.Z */
Call Stream syslvl,'C','CLOSE'
num1  = c2x(Substr(file,41,2))
num2  = c2x(Substr(file,150,1))
P390rel = Substr(num1,1,1)                     /* X.  .   */
P390lvl = Substr(num1,2,1)||Substr(num1,4,1)   /*  .YY.   */

If P390rel='2' & P390lvl='03' & num2 = 'B1' then /* Only current Beta is OK */
   num2 = '00'    /* Pretend it's not a beta */
If num2 = 'B1' then do  /* A beta fix level is installed */
   Say 'Current' card 'program level is' P390rel'.'P390lvl'.'x2c(e1)
   Say 'You cannot install on this base because it is a BETA fixpack.'
   Say 'You must back off the BETA by typing:' tpath'\REGRESS.'
   Say 'Obtain and install the' Fix_lvl 'fixpack, or' Base_lvl 'diskettes,'
   Say 'then try this install again.'
   Say '*** Nothing done. ***'
   Exit 2
   End
   /* Note: To create a "Beta" SYSLEVEL.AWS, replace the X'01' byte at offset X'96' with X'B1'  */
   /*       This is ASCII for a grey block (), but SYSLEVEL.EXE displays it as a beta ()  */

Else P390mod = Substr(num2,2,1)                     /*  .  .Z  */

P390_level = P390rel||P390lvl||P390mod
If Substr(num1,2,1) = '0' then P390lvl = Substr(num1,4,1) /* Strip leading zero */
P390_lvl = P390rel'.'P390lvl'.'P390mod

If P390_level >= Base_level | P390_level = Fix_level then nop;
   Else do
   Say 'Current' card 'program level is' P390rel'.'P390lvl'.'P390mod'.'
   Say 'The required level for this installation is either'
   Say 'diskette level 'base_lvl 'or fixpack level' fix_lvl
   Say '*** Nothing done. ***'
   Exit 2
   End;


If tletter <> dletter then
   Say 'Warning: 'tpath' may not be first in the "SET PATH=" statement of CONFIG.SYS.'

Return;

/*--------------------------------------------------------------------*/

ChkPgm:
/*--------------------------------------------------------------------*/
/* Check to see if P/390 code is running                              */
/*--------------------------------------------------------------------*/

/* Check the P/370 I/O subsystem */
y=Stream(tpath'\awsutil.dll','C','OPEN') /* Is it running? */
z=Stream(tpath'\awsutil.dll','C','CLOSE')
If y='NOTREADY:32'  then do
   Say '********************** ERROR *****************************'
   Say 'The' card 'programs on drive' tpath 'may be running.';
   Say 'You must select END' card 'icon and then rerun' srcname
   Say ''
   Say 'If this still fails, then re-boot OS/2 and try again.'
   Say '*** Nothing done ***'
   y=Stream(tpath'\awsutil.dll','C','CLOSE')
   Exit 13
   end

/* Check for other P/370 programs */
n.1='MANOPS.EXE'; n.2='AWSCNF.EXE'; n.3='AWSTRACE.EXE';
Do i=1 to 3
   y.i=Stream(tpath'\'n.i,'C','OPEN') /* Is it running? */
   z.i=Stream(tpath'\'n.i,'C','CLOSE')
   If y.i='NOTREADY:32'  then do
      Say '********************** ERROR *****************************'
      Say 'The' n.i 'program on drive' tpath 'is running.';
      Say 'You must stop this program and then rerun' srcname
      Say '*** Nothing done ***'
      Exit 13
      end
   End;  /* check other pgms */
Return;

/*-------------------------------------------------------------------------------*/

UpConfig:
/*--------------------------------------------------------------------*/
/* - Add C:\RIC\BIN; to the three paths in CONFIG.SYS                 */
/* - Add RICIO16.SYS device driver statements                         */
/*--------------------------------------------------------------------*/

/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'

/* Read in entire config.sys file */
Do i=1 by 1 While Lines(config)
   line.i = Linein(config)
   End
Call Stream config,'C','CLOSE'
lines = (i-1)    /* number of lines read */
If lines = 0 then do
   Say 'NOTE:' config 'was not found so it cannot be updated.'
   Signal Updone
   End

/*                                         */
/*  Update all 3 PATH lines in CONFIG.SYS  */
/*                                         */

parm.1 = 'LIBPATH='; parm.2 = 'SET PATH='; parm.3 = 'SET DPATH='; pup=0;
Do j=1 to 3
   Do i=1 by 1 Until ppath <> ''
      Parse upper var line.i . VALUE(parm.j) ppath
      If i > lines then do
         Say parm.j 'not found!  CONFIG.SYS cannot be updated.'
         Signal Updone
         end
      End

   /*  See if C:\RIC\BIN; is already at beginning of path    */
   sec=0
   semi=Pos(';',ppath)  /* What is the first subdir in path? */
   first=Strip(Substr(ppath,1,semi))
   If first ='.;' then  /* Is it the "dot" ? */
      do       /* Yes, skip to next subdir */
      sec=Pos(';',ppath,semi+1)  /* What is second subdir? */
      first=Strip(Substr(ppath,semi+1,sec-semi))
      End

   /* If RIC path is already there, then don't add or delete anything */
   If first <> ricbpath';' then do     /* RIC is not there  */
   /*  Delete all occurences of C:\RIC\BIN; from anywhere in path    */
      Do until ppRIC = 0
         ppRIC = Pos(ricbpath,ppath)
         If ppRIC = 0 then leave
         ppath = Substr(ppath,1,ppRIC-2)||Substr(ppath,ppRIC+11)
         end
     /* OK, now actually put C:\RIC\BIN; at front of path  */
      If sec <> 0 then do   /* "dot" was first */
         line.i = parm.j'.;'ricbpath';'Substr(ppath,semi+1) /* Insert after "dot" */
         end
      Else do
         line.i = parm.j||ricbpath';'ppath /* Insert as first path */
         end
      pup=j
      End;
   End; /* Update all three path lines */

/*                                                       */
/* See if a valid Artic960 Device Driver is in CONFIG.SYS   */
/*                                                       */
   add=1  /* Set to 0 if a valid device driver statement is found */
   Do i=1 by 1 to lines
      ndd = Pos(ricbpath'\RICIO16.SYS',Translate(line.i))
      If ndd > 0 then do
         pre = Substr(line.i,1,ndd-1)
         Parse Upper Var pre rem device equal .
         If rem = 'REM' then nop  /* Ignore Remarked out statement */
           Else,           /* Is this a valid device statement ? */
           If (rem = 'DEVICE' & device = '='),
             |(rem = 'DEVICE='),
             |(device = 'DEVICE' & equal = '='),
             |(device = 'DEVICE='),
             then add=0    /* valid device driver found */
         end;
       End;  /* i=1 to lines */

/*                                             */
/* Write out a new CONFIG.SYS, if necessary    */
/*                                             */
If (pup>0)|(add=1) then do  /* Skip if no changes necessary */
   /* Save the old CONFIG.SYS and replace it with the new one */
   "@ECHO OFF"
   sav_config = SysTempFileName(Bdrive'\CONFIG.???')
   "COPY" config sav_config
   temp = SysTempFileName(Bdrive'\TEMP.???')
   Do i=1 to lines
      Call Lineout temp,line.i
      End
   If add=1 then do  /* Add Artic960 statements at bottom of file */
      rics = 'REM ---- Artic960 Device Driver --- installed for 'title' ----',
             '0D0A'x,
             'DEVICE='ricbpath'\RICIO16.SYS',
             '0D0A'x,
             'SET RICPATH='ricpath
      Call Lineout temp,rics
      End;
   Call Lineout temp  /* Close output file */
   "COPY" temp config /* Copy new file over old file */
   "ERASE" temp

   Say '*------------------------------------------------------------------------*'
   Say '*' config 'has been updated. Your old file is saved as' sav_config
   Say '* You must reboot your PC for the updates to take effect.'
   Say '*------------------------------------------------------------------------*'
   End;
Else do
   Say ''
   Say 'CONFIG.SYS did not need updating.'
   End;
Updone:
return;

/*------***************************-----------------------------------*/
/*----- E R R O R   R O U T I N E S ----------------------------------*/
/*------***************************-----------------------------------*/

Nospace1:
ndigits=Length(needed);
tdigits=Length(tfree);
tfree=Right(tfree,Max(ndigits,tdigits));
Say ''
Say '** ERROR: Not enough space on drive C: to install' title 'programs.'
Say needed 'bytes ('Trunc(needed/1048576,1) 'MB) are needed on drive C:.  There are only'
Say tfree' bytes ('Trunc(tfree/1048576,1) 'MB) available.'
Say ''
Say 'Free up enough space on drive C: and then rerun 'srcname
Exit 3

NodiskT:
Say ''
Say 'Destination disk' Tletter': does not exist.  Check parameters and rerun' srcname
Exit 2
