/* P/390 3172 SDLC Install program                          3/26/98 JAH        */
/*                                                                             */
/*  2/15/96 JAH 2.1 Original version                                           */
/*  6/05/96 JAH 2.2                                                            */
/* 11/06/96 JAH 2.3.2                                                          */
/*  3/26/98 JAH 2.5 Use tletter instead of tpath in unzip of wan3172           */
/*                                                                             */
trace o
"@ECHO OFF"
card = 'P/390';subd = 'P390';
title = card '3172 SDLC Gateway'
needed = 3355443  /* bytes needed on C: drive for \SNACOM, \ICA, \IBMCOM\etc */

Parse upper arg x .
If x = '?' then do
Say 'Correct Form is:'
Say '                INST3172 [d:]'
Say ''
Say 'Use this command to install the' title 'programs.'
Say '  "d:" is the drive letter of the /P390 subdirectory.'
Say 'Note that some files must also be installed on the C: drive in the'
Say 'C:\ICA, C:\SNACOM, C:\IBMCOM\etc subdirectories.'
Say ''
Say 'Make sure all' card 'programs are stopped before running this install.'
Say 'If you have previously installed this support, older versions will be replaced,'
Say 'EXCEPT for files that are active from CONFIG.SYS. Please "REM" out any'
Say 'WAN3172 related statements before running this install.'
   Exit
   End

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

Parse upper Source . . srcname .  /* Info on the program as called */
sletter = Filespec('Drive',srcname) /* e.g. a:            */
ssubd = Filespec('Path',srcname)    /* e.g. \path\        */
spath = sletter||ssubd              /* e.g. a:\path\      */

complete=0  /* non-zero if OK */
Error=0     /* non-zero if any errors */

Call SysCls
Say ''; Say title 'Installation';
Say '(this is only for MVS SDLC WAN support; not needed for VM, VSE or LAN functions)'
say ''; Say 'To continue with installation press Y';
Say '(any other key to EXIT).';
parse upper value SysGetKey('NOECHO') with key
If key<>'Y' Then Exit 1

/*--------------------------------------------------------------------*/
/* Make sure LAPS is installed on drive C:                            */
/*--------------------------------------------------------------------*/
z0 = stream('C:\IBMCOM\SYSLEVEL.TRP','C','QUERY EXISTS')
If z0 = '' then do
   Say 'LAN Adapter and Protocol Support (LAPS) must be installed in C:\IBMCOM'
   Say 'or else the 3172 SDLC Gateway feature cannot be installed.'
   Say '*** Nothing done. ***'
   Exit 2;
   end
/*--------------------------------------------------------------------*/
/* Check for a drive letter(s) passed as parameter to INSTALL         */
/*--------------------------------------------------------------------*/
   parse upper arg tletter .   /* to drive */
   parse var tletter tletter ':' .  /* strip off : if provided */

Call GetP390  /* Find the P390 drive letter in CONFIG.SYS. Sets "dletter" */

If tletter='' then do
   Say '';
   Say 'What is the drive letter of the \'subd' subdirectory?'
   Say 'Type in the letter of the destination disk (To accept default = 'dletter', press ENTER).';
   parse upper value SysGetKey('NOECHO') with key
   If key='0D'x Then Do
                    tpath=dletter':\'subd
                    tletter=dletter;
                    end;
                Else Do
                    tpath=key':\'subd
                    tletter=key;
                    end;
   end
   Else tpath=tletter':\'subd

If (length(tletter)<>1 | Datatype(tletter,'U')<>1) Then do
   Say "Invalid parameter: '"tletter"'. It must be a valid OS/2 drive letter."
   Say '*** Nothing done. ***'
   Exit 1;
   End;

z1 = stream(tpath'\AWSERRS.EXE','C','QUERY EXISTS')
If z1 = '' then do
   Say 'The P/390 Programs are not installed in' tpath
   Say '*** Nothing done. ***'
   Exit 2;
   end

Call ChkPgm  /* check to see is any P/390 programs are running */

Say 'Installing' title'...'
Say ''
/*--------------------------------------------------------------------*/
/* Check free space on the C: drive                                   */
/*--------------------------------------------------------------------*/
tinfo = SysDriveInfo('C:')
If tinfo = '' then Signal NodiskT
Parse var tinfo . tfree . .
If tfree < needed then Signal Nospace1

/*--------------------------------------------------------------------*/
/* Unzip the files                                                    */
/*  File 1: \SNACOM,\ICA, and \IBMCOM\etc,  files                     */
/*  File 2: \P390 files                                               */
/*--------------------------------------------------------------------*/
filename1 = 'SNA3172.ZIP'
filename2 = 'WAN3172.ZIP'

/* Make sure we have the unzip program */
z2 = stream(tpath'\PKUNZIP2.EXE','C','QUERY EXISTS')
If z2 <> '' then zpath = tpath'\'
Else Do
   z3=SysSearchPath('PATH','PKUNZIP2.EXE')
   If z3 = '' then do
      Say 'Required program PKUNZIP2.EXE not found. P/390 Program diskettes must be installed.'
      Say '*** Nothing done. ***'
      Exit 3;
      End
   Else zpath = ''
   End; /* Search for a copy */

Say 'Unzipping ' filename1 'to C:\RIC, C:\SNACOM, C:\IBMCOM...';
zpath"PKUNZIP2 -o -d "spath||filename1 "C:\"
z2rc=rc
If z2rc <> 0 then error = error + 1
If z2rc = 1 Then Say 'Some active files could not be replaced, installation continues...'
If z2rc > 1 then Do
   Say '** ERROR unzipping' filename1'. See error messages listed above.'
   Exit z2rc /* QUIT */
   End; /* error */

Say 'Unzipping ' filename2 'to' tpath '...';
zpath"PKUNZIP2 -o -d "spath||filename2 tletter":\"
z1rc=rc
If z1rc <> 0 then Do
   Say '** ERROR unzipping' filename2'. See error messages listed above.'
   Exit z1rc /* QUIT */
   End; /* error */

complete=complete+1       /* non-zero if we have completed this step */

/*--------------------------------------------------------------------*/
/*  E X I T  code                                                     */
/*--------------------------------------------------------------------*/
Exit:
If complete > 0 then do  /* Only say if we have actually done something */
   Say ''
   If error<>0 then Do
      Say title 'installation done, but errors occurred.'
      Say '------------------------------------------------------------'
      If z2rc = 1 then do
         Say 'If you were reinstalling these programs and some files could'
         Say 'not be replaced, "rem" out all the WAN3172 related statements'
         Say 'in CONFIG.SYS, reboot OS/2, and retry this install.'
         End
      End
   Else Do
      Say title 'installation is complete.'
      Say '-------------------------------------------------'
      Say ''
      Say 'Continue with the instructions in the file C:\SNACOM\README.SNA.'
      End; /* No errors */
Exit 0
/*------***************************-----------------------------------*/
/*----- S U B R O U T I N E S       ----------------------------------*/
/*------***************************-----------------------------------*/
GetP390:
/*---------------------------------------*/
/* Find what drive P/390 programs are on */
/*---------------------------------------*/
/* Find the boot drive  */
Bdrive=filespec('DRIVE',value('COMSPEC',,'OS2ENVIRONMENT'))
config=Bdrive'\CONFIG.SYS'

/* Read in CONFIG.SYS file one line at a time */
Do i=1 by 1 While Lines(config)
   cline = Linein(config)
   Parse upper var cline rem .
   If Strip(rem) = 'REM' then iterate
   Parse upper var cline . 'SET PATH=' ppath
   If ppath <> '' then leave /* Found the line we want */
   End;
Call Stream config,'C','CLOSE'
If ppath = '' then do  /* If we can't locate CONFIG.SYS, take default */
   dletter='D'
   Return
   End;

/*                                                             */
/*  Extract drive letter from first d:\P390; statement on line */
/*                                                             */
pp390 = Pos(':\'subd';',ppath)
If pp390 = 0 then do  /* Can't find one */
   dletter='D' /* Can't find P390 - assume default */
   Return
   End;

dletter = Substr(ppath,pp390-1,1)  /* Grab P390 drive letter */
If (length(dletter)<>1 | Datatype(dletter,'U')<>1) Then dletter = 'D';
dpath=dletter':\'subd

Return;

/*--------------------------------------------------------------------*/

ChkPgm:
/*--------------------------------------------------------------------*/
/* Check to see if P/390 code is running                              */
/*--------------------------------------------------------------------*/

/* Check the P/370 I/O subsystem */
If Running(tpath'\awsutil.dll') then do
   Say '********************** ERROR *****************************'
   Say 'The' card 'programs on drive' tpath 'may be running.';
   Say 'You must select END' card 'icon and then rerun INSTALL.'
   Say ''
   Say 'If INSTALL still fails, then re-boot OS/2 and try again.'
   Say '*** Nothing installed ***'
   Exit 13
   end

/* Check for other P/370 programs */
n.1='MANOPS.EXE'; n.2='AWSCNF.EXE'; n.3='AWSTRACE.EXE';
Do i=1 to 3
   If Running(tpath'\'n.i) then do
      Say '********************** ERROR *****************************'
      Say 'The' n.i 'program on drive' tpath 'is running.';
      Say 'You must stop this program and then rerun INSTALL.'
      Say '*** Nothing installed ***'
      Exit 13
      end
   End;  /* check other pgms */
Return;

Running: procedure
Arg fn
If Stream(fn,'C','QUERY EXISTS')<>''then do  /* Does it exist? */
   y=Stream(fn,'C','OPEN')   /* Open for read & write */
   z=Stream(fn,'C','CLOSE')  /* Close the file */
   End
   If y='NOTREADY:32' then run=1
   else run=0
Return run;

/*------***************************-----------------------------------*/
/*----- E R R O R   R O U T I N E S ----------------------------------*/
/*------***************************-----------------------------------*/

Nospace1:
ndigits=Length(needed);
tdigits=Length(tfree);
tfree=Right(tfree,Max(ndigits,tdigits));
Say ''
Say '** ERROR: Not enough space on drive C: to install' title
Say needed 'bytes ('Trunc(needed/1048576,1) 'MB) are needed on drive C:.  There are only'
Say tfree' bytes ('Trunc(tfree/1048576,1) 'MB) available.'
Say ''
Say 'Free up enough space on drive C: and then rerun 'srcname
Exit 3

NodiskT:
Say ''
Say 'Destination disk' Tletter': does not exist.  Check parameters and rerun' srcname
Exit 2
