/*
  Use RXHLLAPI to find local VSE operator console.
  If one is found, prompt to see if the user wants to shut down
  gracefully, shutdown right away, or cancel the request.

  Change History:
    3/17/95 CICS Remove from I from CEMT P SHUT I
    4/27/95 VSE2 Update for VSE 2.1.
*/
arg YESNO .
/* --------------------------------------------------- */
/* USER ALTERABLE SECTION...                           */
/* VARIABLES THAT MIGHT CHANGE DEPENDING ON YOUR SETUP */
/* --------------------------------------------------- */


HalfSeconds = 16          /* # of half seconds to wait for Host reply */
GlobalNumAttempts = 3     /* # of attempts between pauses */


/* --------------------------------------------------- */
/* Initializers of Rexx HLLAPI using above VARIABLES.  */
/* Ensure that 'Shortname'/'Longname' point to the     */
/* same session.                                       */
/* Connect to the desired session.                     */
/* Prepare to send info to Host/Wait for Replies.      */
/* --------------------------------------------------- */
call InitRx
specsess = find_vse();

OperatorSessionID=specsess;
if specsess=''
   then do;
            say 'VSE master console not found'
            exit 1;
        end;

if pos('EOJ NO NAME',z)>0
   then do;
             say 'VSE already shut down';
             exit 4;
        end;
if yesno='/ASK'
   then do;
            awspopup  16389  ,   /* Yes, No, Cancel*/
            '"Yes.....Shutdown VSE and end'||'01'x ||,
            'No.......End without shutting down'||'01'x||,
            'CANCEL...Do nothing"',
            '"END VSE"'
            if rc=2 then exit 2;    /* 2 = cancel            */
            if rc=7 then exit 4;    /* 7 = No, kill it       */
                                    /* 6 = Yes, try shutdown */
        end;

say 'VSE master console on session' specsess

call ReadyToSend
/* -----------------------------------------------------------      */
/* USER ALTERABLE SECTION...                                        */
/* THESE STATEMENTS CAN BE ALTERED TO SUIT YOUR SHUTDOWN NEEDS      */
/* FOR COMMUNICATION TO/FROM THE VSE SYSTEM CONSOLE.                */
/* START OF REGULARLY ALTERABLE STATEMENTS.                         */
/* VSE 2.x added an extra number in messages "0015" instead    VSE2 */
/* just "015", we we modified the wait-for-reply to accomodate VSE2 */
/* both versions.                                              VSE2 */
/* -----------------------------------------------------------      */
call SendK('0-msg f2')
call ShortDelay
call ShortDelay
/*ll WaitForReply('AR 015 1I40I  READY') */                 /* VSE2 */
call WaitForReply('015 1I40I  READY')                       /* VSE2 */
if result=0 then call noresp;

/*--------------------------------------------------------------------*/
/* Delay for 4 seconds, because the earlier attention command may     */
/* return extra data.  This will hopefully wait until it's all back.  */
/*--------------------------------------------------------------------*/
call LongerDelay

call SendK('0-02 cemt p shut ')                        /* CICS */
call ShortDelay
/*ll WaitForReply('F1 001 1Q34I   F2 WAITING FOR WORK') */  /* VSE2 */
call WaitForReply('001 1Q34I   F2 WAITING FOR WORK')        /* VSE2 */
if result=0 then call noresp;

call SendK('0-z net,quick')
call ShortDelay
/*ll WaitForReply('F1 001 1Q34I   F3 WAITING FOR WORK') */  /* VSE2 */
call WaitForReply('001 1Q34I   F3 WAITING FOR WORK')        /* VSE2 */

call SendK('0-pend')
call ShortDelay
/*ll WaitForReply('*F1-001 1C10D  PLEASE ASSIGN SYSRDR') */ /* VSE2 */
call WaitForReply('001 1C10D  PLEASE ASSIGN SYSRDR')        /* VSE2 */

call SendK('0-1 /&')
call ShortDelay
/*ll WaitForReply('*F1-001 EOJ NO NAME') */                 /* VSE2 */
call WaitForReply('001 EOJ NO NAME')                        /* VSE2 */


/* No waiting for system response just check if these are on the screen
*
* Removed, these calls represent examples of usage
*
*call InstantCheck('DATE')
*call InstantCheck('CLOCK')
*/

/* ----------------------------------------------------------- */
/* THESE STATEMENTS CAN BE ALTERED TO SUIT YOUR SHUTDOWN NEEDS */
/* FOR COMMUNICATION TO/FROM THE VSE SYSTEM CONSOLE.           */
/* END OF REGULARLY ALTERABLE STATEMENTS.                      */
/* ----------------------------------------------------------- */
call StopSending

call RemoveHllapi

EXIT 0;

/* ---------------------------------------------------------------- */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* NOTE: There should not be any immediate needs to change any code */
/*       beneath this point.                                        */
/* ---------------------------------------------------------------- */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* PLEASE READ THIS NOTE!                                           */
/* ---------------------------------------------------------------- */

/* ---------------- */
/* Procedures/Tools */
/* Procedures/Tools */
/* Procedures/Tools */
/* Procedures/Tools */
/* ---------------- */

/* -------------------------- */
/* Hit the enter key FUNCTION */
/* -------------------------- */

EK:
Say 'Hit enter to continue ...'
pull .
say
say
return


/* ----------------------- */
/* Respond Y or N FUNCTION */
/* ----------------------- */

OK:
Say 'Type Y to accept/continue, any other key to exit.'
parse upper pull anss
if (anss <> 'Y') then do
 say 'User has chosen to exit'
 say 'User has chosen to exit'
 say 'User has chosen to exit'
 Call EK
 Call RemoveHllapi
 EXIT
end
say
say
return


/* ----------------------- */
/* Error Handling FUNCTION */
/* ----------------------- */

ERREXIT: VAR1
Say 'We have encountered an error 'VAR1
say 'Now exiting GetChosn.CMD...'
Call EK
Call RemoveHllapi
EXIT

/* ------------------------------- */
/* Initialize the Rexx Message Box */
/* ------------------------------- */

InitRxMsgBox:
if rxfuncquery('SysLoadFuncs') then
 do
   rc = rxfuncadd( 'SysLoadFuncs','RexxUtil','SysLoadFuncs')
   if (rc <> 0) then do
     say 'On funcadd SysLoadFuncs, returned NOT successful'
     call OK
   end
   Else
     call SysLoadFuncs
 end
else do
   call SysDropFuncs /* first get rid of it, hopefully PMREXX too */

   /* now put it back in */
   rc = rxfuncadd( 'SysLoadFuncs','RexxUtil','SysLoadFuncs')
   if (rc <> 0) then do
     say 'On funcadd SysLoadFuncs, returned NOT successful'
     call OK
   end
   Else
     call SysLoadFuncs
end
return

/* ----------------------- */
/* Initialize the RXHLLAPI */
/* ----------------------- */

InitRx:
if rxfuncquery('hllapi') then
 do
   rc = rxfuncadd( 'hllapi','saahlapi','hllapisrv')
   if (rc <> 0) then do
     say 'On funcadd, returned NOT successful'
     call OK
   end
   /* - this is acceptable so leave it off
   if (rc = 0) then
     say 'On funcadd, returned successful'
   */
 end
/* - this is acceptable so leave it off
else
  say 'hllapi must already be registered'
*/
return


/* ------------------------- */
/* Delay - Shortest Possible */
/* ------------------------- */

ShortDelay:
/* ----------------------------------------------------------------- */
/* Change temporarily to a Real Pause, and pause short 1 half second */
/* ----------------------------------------------------------------- */
rc = HLLAPI('Set_Session_Parms',FPAUSE)
if (rc <> 0) then do
  say 'Should Never see this error - SD1'
  say 'Set_Session_parms FPause failed rc = 'rc
  CALL OK
end

/* --------------------------------------------------- */
/* Perform a hard pause for the shortest time possible */
/* --------------------------------------------------- */
rc = HLLAPI('PAUSE',1)
if ((rc <> 0)&(rc <> 26)) then do
  say 'Should Never see this error - SD2'
  say 'REAL Pause failed rc = 'rc
  CALL OK
end


/* ------------------------------------------------------- */
/* Now back to a Interruptable Pause for normal processing */
/* ------------------------------------------------------- */
rc = HLLAPI('Set_Session_Parms',IPAUSE)
if (rc <> 0) then do
  say 'Should Never see this error - SD3'
  say 'Set_Session_parms IPause failed rc = 'rc
  CALL OK
end

return


/* ------------------------- */
/* Delay - A little longer   */
/* ------------------------- */

LongerDelay:
/* ----------------------------------------------------------------- */
/* Change temporarily to a Real Pause, and pause short 8 half second */
/* ----------------------------------------------------------------- */
rc = HLLAPI('Set_Session_Parms',FPAUSE)
if (rc <> 0) then do
  say 'Should Never see this error - LD1'
  say 'Set_Session_parms FPause failed rc = 'rc
  CALL OK
end

/* --------------------------------------------------- */
/* Perform a hard pause for the shortest time possible */
/* --------------------------------------------------- */
rc = HLLAPI('PAUSE',8)
if ((rc <> 0)&(rc <> 26)) then do
  say 'Should Never see this error - LD2'
  say 'REAL Pause failed rc = 'rc
  CALL OK
end


/* ------------------------------------------------------- */
/* Now back to a Interruptable Pause for normal processing */
/* ------------------------------------------------------- */
rc = HLLAPI('Set_Session_Parms',IPAUSE)
if (rc <> 0) then do
  say 'Should Never see this error - LD3'
  say 'Set_Session_parms IPause failed rc = 'rc
  CALL OK
end

return



/* -------------------------- */
/* Remove HLLAPI from machine */
/* -------------------------- */

RemoveHllapi:

rc = HLLAPI('Reset_System')
if (rc <> 0) then do
  CLS
  say
  say '            VSE Shutdown Problem - Reset System'
  say
  say 'Reset System Failed with return code of 'rc'.'
  say
  say 'It may be acceptable to continue with shutdown as the real'
  say 'work is probably already finished.  But you may want to'
  say 'investigate why the Reset_System failed by checking the'
  say 'return code and checking the reasons for this condition.'
  say
  CALL OK
end
call rxfuncdrop('hllapi')

Return


/* --------------------- */
/* Ready To Send to Host */
/* --------------------- */

ReadyToSend:

/* - Removed CAM-5/11/94 Suspect problem locking entire system keyboard
*rc = HLLAPI('Reserve')
*if (rc <> 0) then do
*  say 'Reserve Failed rc = 'rc
*  CALL OK
*end
*/

/* Note: SrchAll already a Default setting */

rc = HLLAPI('Set_Session_Parms',IPAUSE)
if (rc <> 0) then do
  say 'Set_Session_parms IPause failed rc = 'rc
  CALL OK
end

/* Only look for PS (P) updates on the host session */
rc = HLLAPI('Start_Host_Notify',OperatorSessionId,'P')
if (rc <> 0) then do
  say 'Start_Host_Notify B P failed rc = 'rc
  CALL OK
end

return


/* -------------------------------------- */
/* Immediately Check the For Host a Reply */
/* -------------------------------------- */

InstantCheck:
arg srchString
/*
'0' - no update since last call
'1' - not connected to a session
'8' - Host notification has not been requested (see the
      Start_Host_Notify call later)
'9' - system error
'21' - The OIA has been updated
'22' - The Presentation space has been updated
'23' - both OIA and PS have been updated
*/

    rc = HLLAPI('Query_Host_Update',OperatorSessionId)
    if ((rc = 22)|(rc = 23)|(rc = 0)) then do /* This is the expected Rc */
      rc = HLLAPI('Search_Ps',srchString,0)  /* position ignored, cause SRCHALL */

      if (rc <> 0) then do /* Found the srchString */
        do_nothing = 1
        /* say "SUCCESS - Found the search string " srchString */
      end
      else do  /* Problem - did not find the string */
        CLS
        say
        say '           VSE Shutdown Warning - Instant Check'
        say
        say 'The search string 'srchString' was Not Found on the current'
        say 'session of the host 'OperatorSessionId'.'
        say
        say 'This might not be a major problem, since the search string'
        say 'could have been located on the last screen.  But this problem'
        say 'should be researched and fixed.'
        CALL OK
      end
    end
    else if (rc = 21) then
      do_nothing = 1
    else do /* only report the problems */
      if (rc = 1) then
        say 'Query_Host_Update Failed: 1 - not connected to a session'
      else if (rc = 8) then
        say 'Query_Host_Update Failed: 8 - Host notification has not been requested'
      else if (rc = 9) then
        say 'Query_Host_Update Failed: 9 - System error'
      else
        say 'Query_Host_Update Failed: 'rc 'Unknown error'

      CALL OK
    end

return


/* ---------------------- */
/* Wait For Host to Reply */
/* ---------------------- */

WaitForReply:
arg srchString

NumAttempt = 0
WithInTimeLimits = 'TRUE'
FoundIt    = 0;   /* didn't find it */

DO WHILE (WithInTimeLimits = 'TRUE')

  /* --------------------------------------------------------------- */
  /* Wait up to HalfSeconds half seconds for a reply - now 8 seconds */
  /* This is an Interruptable Pause.                                 */
  /* --------------------------------------------------------------- */
  rc = HLLAPI('PAUSE',HalfSeconds)
  if (rc = 9) then do
    say 'Should Never see this error - WFR1'
    say 'Pause Failed, Internal System Error, rc = 'rc
    WithInTimeLimits = 'FALSE'  /* an error, get out */
    CALL OK
  end
  else if (rc = 26) then do /* Must have gotten something within the Time Limit */

    rc = HLLAPI('Query_Host_Update',OperatorSessionId)
    if (rc = 22) | (rc = 23) then do
      /* This is the expected Rc , 22 = PS update, 23 = PS update+OIA update */
      NumAttempt = 0  /* reset number attempts to zero */
      rc = HLLAPI('Search_Ps',srchString,0)  /* position ignored, cause SRCHALL */

      if (rc <> 0) then do /* Found the srchString */
        /* say "SUCCESS - Found the search string " srchString */
        WithInTimeLimits = 'FALSE'  /* Not really an error just get out */
        Foundit=1;  /* we found it */
      end
    end
    else if (rc = 21) then
      /* just ignore this update to the OIA, only want PS updates*/
      NumAttempt = 0
    else do
      say 'Should Never see this error - WFR2'
      say 'Query_Host_Update Failed rc = 'rc
      say 'possible return codes:'
      say '0  - No updates since last call - Impossible'
      say '1  - Invalid host PS specified'
      say '8  - No prior START HOST NOTIFICATION'
      say '9  - System Error'
      WithInTimeLimits = 'FALSE'  /* an error, get out */
      CALL OK
    end

  end
  else do /* Probably a 0 - Wait duration exceeded */
    /* say 'Pause Failed rc = 'rc  let the 3rd attempt say something */
    NumAttempt = NumAttempt + 1

    /* Lets check the PS again for the searched string */
    rc = HLLAPI('Search_Ps',srchString,0)  /* position ignored, cause SRCHALL */

    if (rc <> 0) then do /* Found the srchString */
      WithInTimeLimits = 'FALSE'  /* Were done, now get out */
      FoundIt=1;
      /*CALL EK*/
    end

    else if (NumAttempt = GlobalNumAttempts) then do
      /* ------------------------------------------------------ */
      /* this code represents a true time-out.                  */
      /* On May 27, 1994 - Pat has asked that this be hidden    */
      /*                   so the interaction was removed.      */
      /* ------------------------------------------------------ */
      WithInTimeLimits = 'FALSE'  /* an error, get out */
      /*
      *say 'No Data to Receive'
      *CALL OK
      */
    end

    else
      keeplooking = 'TRUE'  /* just a bogus thing to keep going */
  end
END

return foundit;


/* -------------------- */
/* Stop Sending to Host */
/* -------------------- */

StopSending:

rc = HLLAPI('Stop_Host_Notify',OperatorSessionId)
if (rc <> 0) then do
  say 'Stop_Host_Notify Failed rc = 'rc
  CALL OK
end

/*
*rc = HLLAPI('Set_Session_Parms',IPAUSE)
*if (rc <> 0) then do
*  say 'Set_Session_parms IPause failed rc = 'rc
*  CALL OK
*end
*/

/* - Removed CAM- Suspect problem locking entire system keyboard
*rc = HLLAPI('Release')
*if (rc <> 0) then do
*  say 'Release failed rc = 'rc
*  CALL OK
*end
*/

return


/* --------------------- */
/* Query System FUNCTION */
/* --------------------- */

QueryS:

rc = HLLAPI('Query_system')
say '2nd attempt'
say 'the value returned was 'rc
say 'the lbrk.0 returned was 'lbrk.0
say
if (rc <> '') then do
  HllVer = SUBSTR(rc,1,1);   say 'Version is HllVer 'HllVer  /* 1 */
  HllLvl = SUBSTR(rc,2,2);   say 'Level   is HllLvl 'HllLvl  /* 23 */
  HllDte = SUBSTR(rc,4,6);   say 'Date    is HllDte 'HllDte  /* 456789 */
  Hllun1 = SUBSTR(rc,10,3);  say 'Unused is         'Hllun1  /* -12 */
  Hllbas = SUBSTR(rc,13,1);  say 'Base    is Hllbas 'Hllbas  /* 3 */
  HllX   = SUBSTR(rc,14,1);  say 'X       is HllX   'HllX    /* 4 */
  Hllseq = SUBSTR(rc,15,2);  say 'Seq     is Hllseq 'Hllseq' bin'  /* 56 */
  Hllcpn = SUBSTR(rc,17,2);  say 'CntPrg# is Hllcpn 'Hllcpn  /* 78 */
  Hll1   = SUBSTR(rc,19,1);  say '1       is Hll1   'Hll1    /* 9 */
  Hller1 = SUBSTR(rc,20,4);  say 'Errcod1 is Hller1 'Hller1  /* -123 */
  Hller2 = SUBSTR(rc,24,4);  say 'Errcod2 is Hller1 'Hller2  /* 4567 */
  Hllmod = SUBSTR(rc,28,2);  say 'Model   is Hllmod 'Hllmod' bin'  /* 89 */
  Hllpag = SUBSTR(rc,30,2);  say 'codepag is Hllpag 'Hllpag' bin'  /* -1 */
  Hlltyp = SUBSTR(rc,32,1);  say 'type    is Hlltyp 'Hlltyp  /* 2 */
  Hllun2 = SUBSTR(rc,33,3);  say 'Unused  is Hllun2 'Hllun2  /* 345 */
  call EK

  /* Parse apart the Model */
  say
  Hllmoda = c2d(reverse(Hllmod)); say  'Converted Hllmod =  'Hllmoda
  Hllmod1 = SUBSTR(Hllmod,1,1)   ; say 'Hllmod1 =           'Hllmod1
  Hllmod2 = SUBSTR(Hllmod,2,1)   ; say 'Hllmod2 =           'Hllmod2
  mod1 =    c2x(reverse(Hllmod1)); say 'Converted Hllmod1 = 'mod1
  mod2 =    c2x(reverse(Hllmod2)); say 'Converted Hllmod2 = 'mod2

  /* Parse apart the Codepage */
  say
  Hllpaga = c2d(reverse(Hllpag)); say  'Converted Hllpag =  'Hllpaga
  Hllpag1 = SUBSTR(Hllpag,1,1)   ; say 'Hllpag1 =           'Hllpag1
  Hllpag2 = SUBSTR(Hllpag,2,1)   ; say 'Hllpag2 =           'Hllpag2
  pag1 =    c2x(reverse(Hllpag1)); say 'Converted Hllpag1 = 'pag1
  pag2 =    c2x(reverse(Hllpag2)); say 'Converted Hllpag2 = 'pag2


end
call EK

/*
Returns a 35 byte system configuration string or '' if an error occurred. The
layout of the 35 bytes is as follows:

:li.1 byte HLLAPI version (ascii)
:li.2 byte HLLAPI level (ascii)
:li.6 bytes MMDDYY HLLAPI date (ascii)
:li.3 bytes of not used data
:li.1 byte hardware base, 'Z' means look at system bytes later, 'U' means
unable to determine, system bytes not valid
:li.1 byte of 'X'
:li.2 byte binary (stored in normal Intel reverse order) sequence number
:li.2 bytes (ascii) of the control program number
:li.1 byte of '1'
:li.4 byte ascii Extended Error code 1
.rc 1 on
:li.4 byte ascii Extended Error code 2
.rc 1 off
:li.2 byte binary (stored in normal Intel reverse order) of the  hardware
base and sub-model types
:dl.
:dt.x'FC00'
:dd.6 mhz AT
:dt.x'FC01'
:dd.8 mhz AT
:dt.x'FC02'
:dd.XT 286
:dt.x'FC04'
:dd.PS/2 Model 50
:dt.x'FC05'
:dd.PS/2 Model 60
:dt.x'F800'
:dd.PS/2 Model 80
:dt.x'F801'
:dd.PS/2 Model 70
:edl.
:li.2 byte binary (stored in standard Intel reverse order) of the PC code
page being used
:li.1 byte value identifying the display type being used
:dl.
:dt.'C'
:dd.CGA
:dt.'E'
:dd.EGA
:dt.'V'
:dd.VGA
:dt.'H'
:dd.8514
:dt.'A'
:dd.8503
:dt.'U'
:dd.Unknown
:edl.
:li.3 bytes reserved and unused

*/
return


/* ----------------------- */
/* Query Sessions FUNCTION */
/* ----------------------- */

QuerySes:

rc = HLLAPI('Query_sessions')
say 'the value returned was 'rc
say 'the lbrk.0 returned was 'lbrk.0
say
if (rc <> '') then do
  Hll1   = SUBSTR(rc,1,1);   say 'ShortNamis Hll1   'Hll1    /* 1 */
  HllLng = SUBSTR(rc,2,8);   say 'Longnameis HllLng 'HllLng  /* 23456789 */
  Hllh   = SUBSTR(rc,10,1);  say 'H       is Hllh   'Hllh    /* - */
  Hllps  = SUBSTR(rc,11,2);  say 'PS size is        'Hllps' bin' /* 12 */

  /* Parse apart the PS  */
  say
  Hllpsa = c2d(reverse(Hllps)); say  'Converted Hllps =     'Hllpsa
  Hllps1 = SUBSTR(Hllps,1,1)   ; say 'Hllps1 =              'Hllps1
  Hllps2 = SUBSTR(Hllps,2,1)   ; say 'Hllps2 =              'Hllps2
  ps1 =    c2d(reverse(Hllps1)); say 'DecConverted Hllps1 = 'ps1
  ps2 =    c2d(reverse(Hllps2)); say 'DecConverted Hllps2 = 'ps2

/*
 returns 12 bytes for each configured session or '' if an error occurred. The
12 bytes for each session are as follows:

 - 1 byte session short name
 - 8 byte session long name in ascii
 - 1 byte session type 'H'
 - 2 byte binary number (stored in standard Intel reversed format)
     containing the presentation space size for that session.

  NOTE:for the last field (pssize) use c2d(reverse(x)) after parsing
  it out of the string to get the decimal value


*/
end
call EK

return

/* ------------------------------- */
/* Query specific Session FUNCTION */
/* Update: CAM-5/10 Allow passing of a specific string (eg. B) */
/* ------------------------------- */

QuerySpecSes:PROCEDURE EXPOSE specsess Longname




if ((specsess = '')|(specsess = 'specsess')|(LENGTH(specsess)>1)) then
do
  say 'Query a Specific Session'
  say
  say 'Please enter the Short Name (eg. B)'
  parse upper pull specsess .
end

rc = HLLAPI('Query_Session_Status',specsess)
/*
say 'the value returned was 'rc
say 'the lbrk.0 returned was 'lbrk.0
say
*/

noProblem = 'FALSE'

if (rc <> '') then do
  noProblem = 'TRUE'

  Hll1   = SUBSTR(rc,1,1); /*  say 'ShortNamis Hll1   'Hll1    * 1 */
  HllLng = SUBSTR(rc,2,8); /*  say 'Longnameis HllLng 'HllLng  * 23456789 */
  /*
  Hlltyp = SUBSTR(rc,10,1);  say 'Typ     is Hlltyp 'Hlltyp  * - *
  Hllfea = SUBSTR(rc,11,1);  say 'Feature is Hllfea 'Hllfea  * 1 *
  Hllr   = SUBSTR(rc,12,2);  say 'rows    is Hllr   'Hllr    * 23 *
  Hllc   = SUBSTR(rc,14,2);  say 'cols    is Hllc   'Hllc    * 45 *
  Hllcp  = SUBSTR(rc,16,2);  say 'cp      is Hllcp  'Hllcp   * 67 *

  call EK
  */


  /* Parse apart the row *
  say
  Hllra = c2d(reverse(Hllr)); say  'Converted Hllr =     'Hllra
  Hllr1 = SUBSTR(Hllr,1,1)
  Hllr2 = SUBSTR(Hllr,2,1)
  r1 =    c2d(reverse(Hllr1)); say 'DecConverted Hllr1 = 'r1
  r2 =    c2d(reverse(Hllr2)); say 'DecConverted Hllr2 = 'r2
  */

  /* Parse apart the col *
  say
  Hllca = c2d(reverse(Hllc)); say  'Converted Hllc =     'Hllca
  Hllc1 = SUBSTR(Hllc,1,1)
  Hllc2 = SUBSTR(Hllc,2,1)
  c1 =    c2d(reverse(Hllc1)); say 'DecConverted Hllc1 = 'c1
  c2 =    c2d(reverse(Hllc2)); say 'DecConverted Hllc2 = 'c2
  */

  /* Parse apart the codepage*
  say
  Hllcpa = c2d(reverse(Hllcp)); say  'Converted Hllcp =     'Hllcpa
  Hllcp1 = SUBSTR(Hllcp,1,1)
  Hllcp2 = SUBSTR(Hllcp,2,1)
  cp1 =    c2d(reverse(Hllcp1)); say 'DecConverted Hllcp1 = 'cp1
  cp2 =    c2d(reverse(Hllcp2)); say 'DecConverted Hllcp2 = 'cp2
  */

end

if (HllLng <> Longname) then do
  noProblem = 'FALSE2'
end


if (noProblem <> 'TRUE') then do
  CLS
  say
  say '               VSE Shutdown Problem - Query Session'
  say
  say 'There was a problem trying to locate the 'specsess' session.'
  if (noProblem = 'FALSE2') then do
    say 'As the Longname of the specific session did not match the'
    say 'expected Longname.'
    say
    say 'Expected Longname: 'Longname
    say 'Actual Longname:   'HllLng
    say
    say 'The LongName does not match the expected.  Although this'
    say 'is not a show-stopping problem, the SHTD_VSE.CMD should be'
    say 'be updated with the Actual Longname (if this is correct).'
    say 'Or the reason for the invalid session Longname should be'
    say 'investigated.'
    say
    say 'NOTE: the longname refers to the name in the Switch List for'
    say '      this particular session.'
    say
  end
  else do
    say 'This is not an acceptable condition to attempt to continue'
    say 'the 1-Key Shutdown process.  Please do the following, either:'
    say
    say ' 1. - Verify that VSE is not currently started anyway.'
    say '  -- OR --'
    say ' 2. - Somehow the SHTD_VSE.CMD is pointing to an incorrect session'
    say '      for System Console of VSE.  This would require adjusting the'
    say '      hard-coded variables in the SHTD_VSE.CMD file to point to the'
    say '      correct system console for VSE.'
    say
    say 'This Shutdown procedure will not attempt to continue, as it would'
    say 'be unproductive since the rest of the commands are directed at the'
    say 'emulated 3270 session 'specsess'.'
    say
  end
  call EK
end
/*

returns 18 bytes of session status information if the call is successful or
'' if not. The 18 bytes are layed out as follows:

 - 1 byte session short name
 - 8 byte session long name in ascii
 - 1 byte session type
     'D'- DFT mode session
     'C'- CUT mode session
     'F'- 5250 session

 - 1 byte binary number containing Control Program features
 - 2 byte binary number (stored in normal Intel reversed format) containing
   the number of rows in the session
 - 2 byte binary number (stored in normal Intel reversed format) containing
   the number of columns in the session
 - 2 byte binary number (stored in normal Intel reversed format) containing
   the host code page value.

Note:for the last three fields (row, col, codepage) use c2d(reverse(x))
     after parsing them out of the string to get their decimal values
*/

return



/* --------------- */
/* UNUSED FUNCTION */
/* --------------- */

Unused:
Going = 1
count = 0
DO WHILE Going
  count = count+1
  pull Anns
  say 'on number 'count' we got 'Anns
  say  a
  say 'Pull another?'
  call OK
End
return


/* -------------------------- */
/* Connect presentation space */
/* Update: CAM-5/10 Allow passing of a specific session (eg. B) */
/* -------------------------- */

ConPS:PROCEDURE EXPOSE specsess



if ((specsess = '')|(specsess = 'specsess')|(LENGTH(specsess)>1)) then
do
  say 'Query a Specific Session'
  say
  say 'Please enter the Short Name (eg. B)'
  parse upper pull specsess .
end

rc = HLLAPI('Connect',specsess)
/*
say 'the value returned was 'rc
say 'the lbrk.0 returned was 'lbrk.0
say
*/

if (rc <> '') then
Do
  Hll1   = SUBSTR(rc,1,1);
  if (Hll1 = 0) then  /* this isnt really an error */
   errmsg = 'Connected Successful to session 'specsess
  else if (Hll1 = 1) then
   errmsg =  'Connection Failed to 'specsess' - Invalid Session ID'
  else if (Hll1 = 4) then
   errmsg =  'Connection Failed to 'specsess' - Connect, session busy'
  else if (Hll1 = 5) then
   errmsg =  'Connection Failed to 'specsess' - Connect, session locked'
  else if (Hll1 = 9) then
   errmsg =  'Connection Failed to 'specsess' - System Error'
  else if (Hll1 = 11) then
   errmsg =  'Connection Failed to 'specsess' - Sess already conn to another app'
  else
   errmsg =  'Connection Failed to 'specsess' - Unknown problem'
  if (Hll1 <> 0) then
  do
    CLS
    say
    say '                 VSE Shutdown Problem - Connect'
    say
    say 'There was a problem trying to Connect to the 'specsess' session.'
    say 'This is not an acceptable condition to attempt to continue'
    say 'the 1-Key Shutdown process.'
    say
    say 'Specific Error Message Generated is:'
    say errmsg
    say
    say 'Please do the following, either:'
    say
    say ' 1. - Verify that VSE is not currently started anyway.'
    say '  -- OR --'
    say ' 2. - Verify that the error message is correct, and act accordingly.'
    say
    say 'This Shutdown procedure will not attempt to continue, as it would'
    say 'be unproductive since the rest of the commands are directed at the'
    say 'emulated 3270 session 'specsess'.'
    say
    call EK
  end
end

/*
The session_id is the single character short name of the session you wish to
connect to. See the Communications Manager Configuration services to
determine the names of the sessions configured on your system.
returns

   0 - Connected ok
   1 - Invalid session_id
   4 - Connect, session busy
   5 - Connect, session locked
   9 - System error
   11 - Session already connected to another application

*/

return


/* ------------------------------------------------ */
/* Send Key to current Connected presentation space */
/* Update: CAM-5/10 Allow passing of a specific string (eg. B) */
/* ------------------------------------------------ */

SendK:
arg MSSG


if ((MSSG = '')|(MSSG = 'MSSG')) then
do
  say 'Send a Command to the Current PS'
  say
  say 'Either type a message "0-your msg" or enter 1 of the following'
  say
  say '1 - Enter Key, 2 - Clear Key, 3 - Home Key, 4 - PA2, 5 - Sys Req'
  say '6 - Backspace, 7 - Erase Input'
  say
  say 'PF keys:          21-29 - PF1 thru PF9, 30-32 - PF10 thru PF12'
  say 'Cursor functions: 10-left, 11-Right, 12-up, 13-down, 15-Newline'
  say
  say 'Please enter the Message/Command (eg. FILEL)'
  parse upper pull msgcomm
end
else
  msgcomm = MSSG

regmsg = 'N'
Msglen = LENGTH(msgcomm)
if (SUBSTR(msgcomm,1,2) = '0-') then do
  msgcomm = SUBSTR(msgcomm,3,Msglen)
  regmsg = 'Y'
end
else if (msgcomm = '1') then msgcomm = '@E'
else if (msgcomm = '2') then msgcomm = '@C'
else if (msgcomm = '3') then msgcomm = '@0'
else if (msgcomm = '4') then msgcomm = '@y'
else if (msgcomm = '5') then msgcomm = '@A@H'
else if (msgcomm = '6') then msgcomm = '@<'
else if (msgcomm = '7') then msgcomm = '@A@F'
else if (msgcomm = '10') then msgcomm = '@L'
else if (msgcomm = '11') then msgcomm = '@Z'
else if (msgcomm = '12') then msgcomm = '@U'
else if (msgcomm = '13') then msgcomm = '@V'
else if (msgcomm = '15') then msgcomm = '@N'
else if (msgcomm = '21') then msgcomm = '@1'
else if (msgcomm = '22') then msgcomm = '@2'
else if (msgcomm = '23') then msgcomm = '@3'
else if (msgcomm = '24') then msgcomm = '@4'
else if (msgcomm = '25') then msgcomm = '@5'
else if (msgcomm = '26') then msgcomm = '@6'
else if (msgcomm = '27') then msgcomm = '@7'
else if (msgcomm = '28') then msgcomm = '@8'
else if (msgcomm = '29') then msgcomm = '@9'
else if (msgcomm = '30') then msgcomm = '@a'
else if (msgcomm = '31') then msgcomm = '@b'
else if (msgcomm = '32') then msgcomm = '@c'
else msgcomm = 9999

if (msgcomm <> 9999) then do
  rc = HLLAPI('SendKey',msgcomm)
  /*
  *say 'the value returned was 'rc
  *say 'the lbrk.0 returned was 'lbrk.0
  *say
  *CALL EK
  */
end
if ((rc <> '')&(msgcomm<>9999)) then
Do
  Hll1   = SUBSTR(rc,1,1);
  if (Hll1 = 0) then        /* No need to print out */
   goodmsg = 'Keystrokes sent OK'
  else if (Hll1 = 1) then
   errmsg = 'Not connected to a session'
  else if (Hll1 = 4) then
   errmsg = 'session busy, all keystrokes not sent'
  else if (Hll1 = 5) then
   errmsg = 'Connection Failed to 'specsess' - Connect, session locked'
  else if (Hll1 = 9) then
   errmsg = 'Connection Failed to 'specsess' - System Error'
  else if (Hll1 = 11) then
   errmsg = 'Connection Failed to 'specsess' - Sess already conn to another app'
  else
   errmsg = 'Connection Failed to 'specsess' - Unknown problem'

  if (Hll1 <> 0) then
  do
    CLS
    say
    say '                 VSE Shutdown Problem - Connect'
    say
    say 'There was a problem trying to Connect to the 'specsess' session.'
    say 'This is not an acceptable condition to attempt to continue'
    say 'the 1-Key Shutdown process.'
    say
    say 'Specific Error Message Generated is:'
    say errmsg
    say
    say 'Please do the following, either:'
    say
    say ' 1. - Verify that VSE is not currently started anyway.'
    say '  -- OR --'
    say ' 2. - Verify that the error message is correct, and act accordingly.'
    say
    say 'This Shutdown procedure will not attempt to continue, as it would'
    say 'be unproductive since the rest of the commands are directed at the'
    say 'emulated 3270 session 'specsess'.'
    say
    call EK
  end
end

/*
send the keys as defined by the contents of string.. Up to total of 255 keys
may be sent at a single time. Returns the return code from the sendkey call

 '0' - keystrokes sent
 '1' - not connected to a session
 '4' - session busy, all keystrokes not sent
 '5' - session is in input inhibit state
 '6' - bad keystroke mnemonic

*/

if (regmsg = 'Y') then do
    msgcomm = '@E'
    rc = HLLAPI('SendKey',msgcomm)
    if (rc <> '') then
    Do
      Hll1   = SUBSTR(rc,1,1);
      if (Hll1 <> 0) then do
        say 'Some problem during Keystroke sending: 'rc
        call OK
      end
      /* - acceptable message, no need to display it.
      *else
      *  say 'Keystrokes sent OK'
      */
    end
end

return
/* in VSE version 1, numbers down the left hand side identify the VSE  */
/* master console. The VSE version 2 console doesn't have numbers, but */
/* does have an identifying string in the first line of the screen.    */
find_VSE:procedure expose z;
         Call RxFuncAdd 'Get_LT_Type', 'AWSREXX', 'Get_LT_Type'
         id='';
         lts=Get_LT_Type()
         do i=1 to words(lts);
            if substr(word(lts,i),1,2)\='LA' then iterate i;
            specsess=substr(word(lts,i),3,1);
            rc = HLLAPI('disconnect')
            rc = HLLAPI('Connect',specsess)
            if rc=0
               then do;
                        z=hllapi('Set_session_parms','NEWOIA');
                        z=hllapi('COPY_OIA');
                        if pos('MACH',z)>0 | pos('COMM',z)>0
                           then iterate i;
                        z=hllapi('COPY_PS');
                        /* for VSE/ESA 2.x, 1st line should contain */
                        /* VSE/ESA, SYS, and SYSTEM:              */
                        l1 = substr(z,1,80)   /* top of screen  VSE2 */
                        if wordpos('SYS',l1)>0     ,
                          &wordpos('VSE/ESA',l1)>0 ,
                          &wordpos('SYSTEM:',l1)>0
                          then nop;
                        else
                        /* for VSE/ESA 1.x, screen has numbers down */
                        /* the left hand side.                    */
                        do j=0 to 5;
                           k=strip(substr(z,1+j*80,3))
                           if datatype(k,'N')=0
                              then iterate i;
                              else if k=j+1
                                      then nop;
                                      else iterate i;
                        end;
                        id=specsess;
                        leave i;
                    end;
         end;
         if id='' then rc=hllapi('disconnect');
         return id;
return; /* find vse */
noresp:
            rc = HLLAPI('disconnect')
        awspopup 16385 '"VSE Not Responding.'||'01'x,
                       'Select OK to END immediatly'||'01'x,
                       'Select Cancel to shutdown VSE manually"' ,
                  '"END VSE"'
           say rc;
           if rc=2 then exit 2;   /* 2 is cancel */
                   else exit 4;   /* 4 is stop anyway */
 return; /* this won't happen... */
