/* IBM Personal/370                                     7/13/93 JAH   */
/*   Build upload & download command files for VM volumes             */
/*                                                                    */
"@ECHO OFF"
Trace o
Parse upper arg dir filemode .
If dir = '' | dir ='?' then do
   Say 'Correct Form is:  '
   Say '                  BLDLIST d:\path  filemode     '
   Say '                                   e:[\path]    '
   Say ''
   Say 'This program will build a file containing all the files in subdirectory d:\path'
   Say 'and put either OS/2 Communications Manager SEND / RECEIVE command syntax'
   Say 'or OS/2 COPY commands around each file name.'
   Say ''
   Say 'If a host minidisk filemode is specified as the second parameter, then '
   Say 'two files will be created:  UPLOAD.LST and DOWNLOAD.LST         '
   Say 'The Comm Mgr 3270 short session ID is assumed to be "A".'
   Say '                                                                '
   Say 'If a OS/2 disk pathname is specified as the second parameter, then'
   Say 'the file COPYFILE.LST will be created.                          '
   Say '                                                                '
   Say 'You can edit the resulting file *.LST, remove any files that you do'
   Say 'NOT want to upload to the host, rename the file to *.CMD, and then use'
   Say 'this file as an OS/2 command file to kick off the actual copy in batch mode.'
   Exit 1
   end


temp= 'UPLOAD.TMP'
x=linein(temp)    /* see if it exists */
call lineout temp /* close it */
If x <> '' then "ERASE" temp  /* erase temp file */

copy = ''
If (Substr(filemode,2,1)=':') then do   /* they want COPY commands */
   copy=   'COPYFILE.LST'
   x=linein(copy)     /* see if it exists */
   call lineout copy /* close it */
   If x <> '' then "ERASE" copy    /* erase output file */
     /* Make sure the parameter is exactly in the form d:\path\    */
        filemode=Strip(filemode)
        new=Strip(filemode,'T','\')||'\'
        new_d=Filespec('Drive',new)
        new_p='\'||Strip(Filespec('Path',new),'L','\')
        new=new_d||new_p
   end
Else do            /* they want SEND / RECEIVE commands */
   up=   'UPLOAD.LST'
   x=linein(up)     /* see if it exists */
   call lineout up /* close it */
   If x <> '' then "ERASE" up    /* erase output file */

   down=  'DOWNLOAD.LST'
   x=linein(down)   /* see if it exists */
   call lineout down /* close it */
   If x <> '' then "ERASE" down  /* erase output file */

   If filemode = '' then filemode = 'D'
   end

"DIR /F" dir ">" temp   /* Create a list of the files */

x=linein(temp,1,0) /* reset file pointer to top */
Do 500
line=linein(temp)  /* Read next line */
If line <> '' then do
   If copy <> '' then do
      os2name = Filespec('N',line)
      copyline='COPY' line new||os2name
      x=lineout(copy,copyline)
      end
   Else do
      os2name = Filespec('N',line)
      Parse var os2name fname '.' fext .
      upline='SEND' line 'a:'fname fext||'BIN' filemode
      x=lineout(up,upline)
      downline='RECEIVE' line 'a:'fname fext||'BIN' filemode
      x=lineout(down,downline)
      end
   end
End

If copy <> '' then do
   x=lineout(copy)  /* close file */
   end
Else do
   x=lineout(up)   /* close file */
   x=lineout(down)  /* close file */
   end
x=lineout(temp)  /* close file */
"ERASE" temp       /* erase temp file */
Exit 0
